// 创建按钮
const backToTopBtn = document.createElement('button');
backToTopBtn.innerText = '↑ Top';
backToTopBtn.style.position = 'fixed';
backToTopBtn.style.bottom = '20px';
backToTopBtn.style.right = '20px';
backToTopBtn.style.padding = '10px 15px';
backToTopBtn.style.backgroundColor = '#007bff';
backToTopBtn.style.color = 'white';
backToTopBtn.style.border = 'none';
backToTopBtn.style.borderRadius = '5px';
backToTopBtn.style.cursor = 'pointer';
backToTopBtn.style.boxShadow = '0 4px 6px rgba(0, 0, 0, 0.1)';
backToTopBtn.style.zIndex = '1000';
backToTopBtn.style.display = 'none'; // 默认隐藏

// 按钮平滑滚动到顶部
backToTopBtn.addEventListener('click', () => {
    window.scrollTo({ top: 0, behavior: 'smooth' });
});

// 添加按钮到页面
document.body.appendChild(backToTopBtn);

// 监听滚动事件，显示/隐藏按钮
window.addEventListener('scroll', () => {
    if (window.scrollY > 300) { // 当滚动超过 300px 时显示按钮
        backToTopBtn.style.display = 'block';
    } else {
        backToTopBtn.style.display = 'none';
    }
});
