// Parameterize agent label
if (params.containsKey('AGENT_LABEL')) {
    AGENT_LABEL = "$params.AGENT_LABEL"
}
pipeline {
    agent { label "${AGENT_LABEL}" }
    parameters {
        string(name: 'AGENT_LABEL', defaultValue: 'labelA')
    }
}

// Substitute pipeline environment variable in shared library code (environment{} block does not work)
withEnv(["ENV_ABC=123"]) {
    script {
        output = lib.function()
        echo "output: ${output}"
    }
}
// In shared library
String function() {
    return "${ENV_ABC}"
}

// Set variable from sh stdout (full and last word)
// note: returnStdout removes the output from jenkins build console log, have to explicitly echo it
script {
    stdout_full = sh (
        script: "ls -ltr",
        returnStdout: true
        ).trim()
    echo "${stdout_full}"
    stdout_last = full_stdout.tokenize().last()
    echo "${stdout_last}"
}

// Active choice (plugin) parameters with dynamic editable user input
// outside pipeline{} block
properties([parameters([
    [$class: 'DynamicReferenceParameter',
        choiceType: 'ET_FORMATTED_HTML',
        omitValueField: true,
        description: 'Editable field when PARENT_PARAM is Others',
        name: 'ACTIVE_PARAM',
        randomName: 'choice-parameter-5631314456178624',
        referencedParameters: 'PARENT_PARAM',
        script: [
            $class: 'GroovyScript',
            fallbackScript: [
                classpath: [],
                sandbox: true,
                script: "return['undefined']"
            ],
            script: [
                classpath: [],
                sandbox: true,
                script:
                    """
                    if(PARENT_PARAM.equals('Others')) {
                        inputBox="<input class='setting-input' name='value' type='text' value=''>"
                    } else {
                        inputBox="<input class='setting-input' name='value' type='hidden' value=''>"
                    }
                    """
            ]
        ]
    ]
])])

// send mail to the executor of job (LDAP)
import hudson.model.User
def userId = currentBuild.rawBuild.getCause(hudson.model.Cause$UserIdCause)?.getUserId()
if (userId) {
    def user = User.get(userId)
    env.user_email = user.getProperty(hudson.tasks.Mailer.UserProperty)?.getAddress()
}


// Check if branch exists on remote
def branchCheckOutput = bat(
    script: "git ls-remote --heads origin ${env.JENKINS_UPLOAD_LABEL}",
    returnStdout: true
).trim()

if (branchCheckOutput =~ /refs\/heads\/${env.JENKINS_UPLOAD_LABEL}/) {
    error "Branch ${env.JENKINS_UPLOAD_LABEL} already exists on remote."
}