import wave
import sys

# Open the WAV file
file_path = sys.argv[1]
with wave.open(file_path, 'rb') as wav_file:
    # Get audio parameters
    channels = wav_file.getnchannels()       # Number of channels (1=mono, 2=stereo)
    sample_width = wav_file.getsampwidth()   # Sample width in bytes
    frame_rate = wav_file.getframerate()     # Sampling frequency (Hz)
    num_frames = wav_file.getnframes()       # Total number of frames

    # Convert sample width to bits
    bit_depth = sample_width * 8

    print(f"Channels: {channels}")
    print(f"Sample Rate: {frame_rate} Hz")
    print(f"Bit Depth: {bit_depth} bits")
    print(f"Number of Frames: {num_frames}")
