#!/bin/bash
# 获取所有已允许的 UFW 端口
allowed_ports=$(sudo ufw status | grep -oP '^\d+')

for port in $allowed_ports; do
    # 检查端口是否在监听
    if ! sudo ss -tuln | grep -q ":$port\s"; then
        echo "Port $port is not in use. Removing allow rule..."
        sudo ufw delete allow "$port"
    else
        echo "Port $port is in use."
    fi
done
